<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Common Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used across multiple language files
    | throughout the application. These common elements are consolidated here
    | to maintain a single source of truth and avoid duplication.
    |
    */

    // Common Entities
    [
        'name' => 'Common Entities',
        'slug' => 'common_entities',
        'properties' => [
            'title' => 'Title',
            'description' => 'Description',
            'name' => 'Name',
            'email' => 'Email',
            'password' => 'Password',
            'type' => 'Type',
            'category' => 'Category',
            'status' => 'Status',
            'location' => 'Location',
            'image' => 'Image',
            'url' => 'URL',
            'categories' => 'Categories',
            'students' => 'Students',
            'courses' => 'Courses',
            'reviews' => 'Reviews',
            'comments' => 'Comments',
            'comment' => 'Comment',
            'price' => 'Price',
            'rating' => 'Rating',
            'instructor' => 'Instructor',
            'role' => 'Role',
            'action' => 'Action',
            'actions' => 'Actions',
            'level' => 'Level',
        ]
    ],

    // Common Status
    [
        'name' => 'Common Status',
        'slug' => 'common_status',
        'properties' => [
            'active' => 'Active',
            'inactive' => 'Inactive',
            'published' => 'Published',
            'draft' => 'Draft',
            'expired' => 'Expired',
            'pending' => 'Pending',
            'enabled' => 'Enabled',
            'disabled' => 'Disabled',
            'language' => 'Language',
            'default' => 'default',
            'closed' => 'Closed',
            'paused' => 'Paused',
            'on' => 'On',
            'off' => 'Off',
            'free' => 'Free',
            'completed' => 'Completed',
        ]
    ],

    // Common Actions & Account Management
    [
        'name' => 'Common Actions & Account Management',
        'slug' => 'common_actions_account_management',
        'properties' => [
            'search' => 'Search',
            'filter' => 'Filter',
            'create' => 'Create',
            'update' => 'Update',
            'edit' => 'Edit',
            'save' => 'Save',
            'delete' => 'Delete',
            'cancel' => 'Cancel',
            'submit' => 'Submit',
            'apply' => 'Apply',
            'view' => 'View',
            'preview' => 'Preview',
            'download' => 'Download',
            'close' => 'Close',
            'confirm' => 'Confirm',
            'yes' => 'Yes',
            'no' => 'No',
            'ok' => 'OK',
            'back' => 'Back',
            'continue' => 'Continue',
            'skip' => 'Skip',
            'retry' => 'Retry',
            'refresh' => 'Refresh',
            'reload' => 'Reload',
            'change_email' => 'Change Email',
            'change_password' => 'Change Password',
            'forget_password' => 'Forget Password',
        ]
    ],

    // Common Status Messages & Time Terms
    [
        'name' => 'Common Status Messages & Time Terms',
        'slug' => 'common_status_messages_time_terms',
        'properties' => [
            'loading' => 'Loading...',
            'processing' => 'Processing...',
            'saving' => 'Saving...',
            'updating' => 'Updating...',
            'deleting' => 'Deleting...',
            'uploading' => 'Uploading...',
            'searching' => 'Searching...',
            'no_results_found' => 'No results found',
            'today' => 'Today',
            'yesterday' => 'Yesterday',
            'ago' => 'ago',
        ]
    ],


    // Common Settings
    [
        'name' => 'Common Settings',
        'slug' => 'common_settings',
        'properties' => [
            'general_settings' => 'General Settings',
            'email_settings' => 'Email Settings',
            'payment_settings' => 'Payment Settings',
            'settings' => 'Settings',
        ]
    ],

    // Common Error Messages
    [
        'name' => 'Common Error Messages',
        'slug' => 'common_error_messages',
        'properties' => [
            'file_too_large' => 'File is too large. Please select a smaller file.',
            'invalid_file' => 'Invalid file format. Please upload a valid .zip file.',
            'required_field' => 'This field is required.',
        ]
    ],

    // Common Navigation
    [
        'name' => 'Common Navigation',
        'slug' => 'common_navigation',
        'properties' => [
            'home' => 'Home',
            'about' => 'About',
            'contact' => 'Contact',
            'help' => 'Help',
            'support' => 'Support',
            'dashboard' => 'Dashboard',
            'settings' => 'Settings',
        ]
    ],

    // Common Pagination
    [
        'name' => 'Common Pagination',
        'slug' => 'common_pagination',
        'properties' => [
            'page' => 'Page',
            'of' => 'of',
            'first' => '<<First',
            'previous' => 'Previous',
            'next' => 'Next',
            'last' => 'Last>>',
            'go_to_page' => 'Go to page',
        ]
    ],

    // Common Media Types
    [
        'name' => 'Common Media Types',
        'slug' => 'common_media_types',
        'properties' => [
            'video' => 'Video',
            'audio' => 'Audio',
            'document' => 'Document',
            'file' => 'File',
        ]
    ],

    // Course Related
    [
        'name' => 'Course Related',
        'slug' => 'course_related',
        'properties' => [
            'free' => 'Free',
            'courses' => 'Courses',
            'students' => 'Students',
            'reviews' => 'Reviews',
            'select_the_approval_status' => 'Select the approval status',
        ]
    ],
];
